from typing import List, Optional

from axelrod.action import Action

from axelrod.player import Player

Vector = List[float]

C, D = Action.C, Action.D

class HardProber(Player):
    """
    Plays D, D, C, C initially. Defects forever if opponent cooperated in moves
    2 and 3. Otherwise plays TFT.

    Names:

    - Hard Prober: [Prison1998]_
    """

    name = "Hard Prober"
    classifier = {
        "stochastic": False,
        "memory_depth": float("inf"),  # Long memory
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        turn = len(self.history)
        if turn == 0:
            return D
        if turn == 1:
            return D
        if turn == 2:
            return C
        if turn == 3:
            return C
        if turn > 3:
            if opponent.history[1:3] == [C, C]:
                return D
            else:
                # TFT
                return D if opponent.history[-1:] == [D] else C